﻿//////////////////////////////////////////////
// Layout.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class Component ;
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "LayoutType.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// Standards
#include <string>

/// Class ------------------------------------

namespace nkWinUi
{	
	class DLL_WINUI_EXPORT Layout : public nkExport::Exportable
	{		
		public :
		
			// Constructor, destructor
			Layout (System* system) noexcept ;
			virtual ~Layout () ;

			// Getters
			Component* getParentComponent () const ;
			System* getSystem () const ;
			LAYOUT_TYPE getType () const ;

			// Setters
			virtual void setParentComponent (Component* parent) ;

			// Components
			virtual void removeComponent (Component* component) = 0 ;

			// Export / Import de base, à redéfinir par les fils s'il faut
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void exportComponentsNodeEntry (nkExport::Node* rootNode) ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;
			virtual void processComponentsNodeEntry (nkExport::Node* rootNode) ;

			// Update !
			virtual void update () = 0 ;

		protected :
		
			// Attributes
			// Parent info
			Component* _parentComponent ;
			System* _system ;

			// Typename
			LAYOUT_TYPE _type ;
	} ;
}